package utilities;

import java.util.List;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Comparator;
import java.util.Collection;
import java.util.Collections;

public class Useful {

    public static <T extends Comparable<? super T>> List<T> sort(Collection<T> c) {
        LinkedList<T> list = new LinkedList<T>();
        for(T t : c)
            list.add(t);
        Collections.sort(list);
        return list;
    }

    public static <T> T[] sort(T[] nodes, Comparator<T> comparator) {
        q_sort(nodes, 0, nodes.length - 1, comparator);
        return nodes;
    }

    private static <T> void q_sort(T[] nodes, int left, int right, Comparator<T> comparator) {
        int l_hold, r_hold;
        T nodePivot = null;

        l_hold = left;
        r_hold = right;
        nodePivot = nodes[left];
        while (left < right) {
            while (comparator.compare(nodes[right], nodePivot) >= 0 && (left < right))
                right--;
            if (left != right) {
                nodes[left] = nodes[right];
                left++;
            }
            while (comparator.compare(nodes[left], nodePivot) <= 0 && (left < right))
                left++;
            if (left != right) {
                nodes[right] = nodes[left];
                right--;
            }
        }
        nodes[left] = nodePivot;
        int pivot = left;
        left = l_hold;
        right = r_hold;
        if (left < pivot)
            q_sort(nodes, left, pivot-1, comparator);
        if (right > pivot)
            q_sort(nodes, pivot+1, right, comparator);
    }

    public static <T> void printCollection(String title, Collection<T> c) {
        System.err.println(title);
        for(T t : c) {
            System.err.println(t);
        }
    }

    public static <T> void removeRepeatedEntries(Collection<T> c) {
        Iterator<T> i = c.iterator();
        T aux = null;
        while(i.hasNext()) {
            if(aux == null)
                aux = i.next();
            else {
                T currentElement = i.next();
                if(currentElement.equals(aux))
                    i.remove();
                else
                    aux = currentElement;
            }
        }
    }
}
