package utilities;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Collection;
import java.util.LinkedList;

/**
 * This class implements some basic operations of list manipulation.
 * Typical operations are the union, difference, and intersection of lists.
 */
public class ListOp {

    /**
     * Diference of lists: i1 - i2
     */
    public static <T> Collection<T> df(Collection<? extends T> i1, Collection<? extends T> i2) {
        HashSet<T> table = new HashSet<T>();
        for(T o : i1) {
            table.add(o);
        }
        for(T o : i2) {
            if(table.contains(o))
                table.remove(o);
        }
        return table;
    }

    /**
     * true if the contents of both lists are the same
     */
    public static <T> boolean eq(Collection<T> i1, Collection<T> i2) {
        if(i1.size() != i2.size()) {
            return false;
        }
        for(T o : i1) {
            if(!i2.contains(o))
                return false;
        }
        return true;
    }

    /**
     * Union of lists: i1 U {o}
     */
    public static <T> Collection<T> un(Collection<T> i1, T newElement) {
        HashSet<T> table = new HashSet<T>();
        for(T o : i1) {
            table.add(o);
        }
        table.add(newElement);
        return table;
    }

    /**
     * Union of lists: i1 U i2
     */
    public static <T> Collection<T> un(Collection<T> i1, Collection<T> i2) {
        HashSet<T> table = new HashSet<T>();
        for(T o : i1) {
            table.add(o);
        }
        for(T o : i2) {
            table.add(o);
        }
        return table;
    }

    /**
     * Intersection of lists: ~(~i1 U ~i2)
     */
    public static <T> Collection<T> it(Collection<T> i1, Collection<T> i2) {
        HashSet<T> table = new HashSet<T>();
        for(T o : i1) {
            if(i2.contains(o))
                table.add(o);
        }
        return table;
    }

    public static <T> Collection<T> cp(Collection<T> src) {
        LinkedList<T> list = new LinkedList<T>();
        for(T o : src) {
            list.add(o);
        }
        return list;
    }

    public static <T> T first(Collection<T> c) {
        Iterator<T> i = c.iterator();
        if(i.hasNext())
            return i.next();
        else
            return null;
    }

}
