package RegAlloc.UCB;

import java.util.Collection;
import java.util.HashMap;

import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import Graph.Node;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.Register;

/**
 * This visitor computes the usage frequency of each register in the control
 * flow graph. The usage frequency is given by the frequency of each instruction
 * in which the register is used or defined.
 * 
 * @author fernando
 * 
 */
public class UseCountCalculator extends DepthFirstSearch<Instruction> {

	private HashMap<Register, Integer> uc;

	private AllocationInstance ai = null;

	public UseCountCalculator(AllocationInstance ai) {
		this.ai = ai;

		// fills the uc table
		this.uc = new HashMap<Register, Integer>();
		for (Node<Register> node : this.ai.ig.getNodes()) {
			Integer userCount = new Integer(0);
			this.uc.put(node.getData(), userCount);			
		}
	}

	public HashMap<Register, Integer> getUseCount() {
		return this.uc;
	}

	public void visit(DiNode<Instruction> n) {
		Instruction inst = n.getData();
		int freq = inst.getFrequency();
		Collection<Register> use = inst.getUseSet();
		for (Register reg : use) {
			Integer oldCount = this.uc.get(reg);
			Integer newCount = new Integer(oldCount.intValue() + freq);
			this.uc.put(reg, newCount);
		}
		Collection<Register> def = inst.getUseSet();
		for (Register reg : def) {
			Integer oldCount = this.uc.get(reg);
			Integer newCount = new Integer(oldCount.intValue() + freq);
			this.uc.put(reg, newCount);
		}
	}

}