package RegAlloc;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

import RegAlloc.IRC.IRC_Alloc;
import RegAlloc.KrParser.FordPrinter;
import RegAlloc.KrParser.FordReader;
import RegAlloc.KrParser.FordReaderImpl;
import RegAlloc.KrParser.InKr;
import RegAlloc.RalfTools.DFA;
import RegAlloc.RalfTools.Debugger;
import RegAlloc.UCB.UCAllocator;

public class TestAllocator {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length < 2) {
			System.err.println("java TestAlg file.mira file.ford");
			System.exit(1);
		} else {
			AllocationInstance ai = InKr.read(args[0]);
			TestAllocator.performRA(ai);
			FordPrinter fp = new FordPrinter(ai, args[1]);
			fp.print();
			if (!TestAllocator.validateResult(args[0], args[1])) {
				int fileExt = (int) (java.lang.Math.random() * Integer.MAX_VALUE);
				System.err.println("The set of allocation directives is semantically inconsistent in " + args[1] + '.' + fileExt);
				TestAllocator.dumpFile(args[0], args[0] + '.' + fileExt);
				TestAllocator.dumpFile(args[1], args[1] + '.' + fileExt);
			} else {
				int fileExt = (int) (java.lang.Math.random() * Integer.MAX_VALUE);
				System.err.println("The set of allocation directives is semantically consistent in " + args[1] + '.' + fileExt);
				TestAllocator.dumpFile(args[0], args[0] + '.' + fileExt);
				TestAllocator.dumpFile(args[1], args[1] + '.' + fileExt);				
			}
		}
	}

	public static void dumpFile(String source, String target) {
		try {
			PrintStream ps = new PrintStream(target);
			BufferedReader in = new BufferedReader(new FileReader(source));
			String str;
			while ((str = in.readLine()) != null) {
				ps.println(str);
			}
			in.close();
			ps.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void performRA(AllocationInstance ai) {
		RegAllocator alloc = new IRC_Alloc();
		alloc.setAllocationParameters(ai);
		alloc.performRegAllocation();
	}

	private static boolean validateResult(String miraFile, String fordFile) {
		AllocationInstance ai = InKr.read(miraFile);
		FordReader fr = new FordReaderImpl(fordFile, ai);
		Debugger.updateInstructions(fr, ai);
		DFA.cleanControlFlowGraph(ai, "0");
		DFA.performLivenessAnalysis(ai, "0");
		return Debugger.searchForBugs(ai);
	}
}