package RegAlloc.SSA;

import java.io.IOException;

import RegAlloc.AllocationInstance;
import RegAlloc.RegAllocator;
import RegAlloc.ChordalAllocation.DMC_Alloc;
import RegAlloc.IRC.IRC_Alloc;
import RegAlloc.KrParser.FordPrinter;
import RegAlloc.KrParser.InKr;
import RegAlloc.RalfTools.DFA;
import RegAlloc.RalfTools.GraphvizGen;

public class SSA_Alloc {

    public static void main(String a[]) throws IOException {
        if(a.length < 2) {
            System.err.println("java5 RegAlloc.SSA.SSA_Alloc in.dat (dmc|irc)");
            System.exit(1);
        } else {
            AllocationInstance ai = InKr.read(a[0]);
            String option = a[1];
            SSA.convertToSSA(ai);
            RegAllocator regAlloc = null;
            if (option.equals("dmc"))
                regAlloc = SSA_Alloc.DMC(ai);
            else if (option.equals("irc")) {
                regAlloc = SSA_Alloc.DMC(ai);
            } else {
                System.err.println("Unknown option: " + option);
                System.err.println("Available options: irc, dmc.");
                System.exit(1);
            }
            DFA.drawControlFlowGraph(ai, "0", "fern.dot", true);
            GraphvizGen gg = new GraphvizGen(ai, regAlloc);
            gg.toGraphviz("result.dot", "XXXXX");
            FordPrinter fp = new FordPrinter(ai);
            fp.print();
        }
    }

    public static RegAllocator IRC(AllocationInstance ai) {
        IRC_Alloc alloc = new IRC_Alloc();
        alloc.setAllocationParameters(ai);
        alloc.performRegAllocation();
        return alloc;
    }

    public static RegAllocator DMC(AllocationInstance ai) {
        DMC_Alloc alloc = new DMC_Alloc();
        alloc.setAllocationParameters(ai);
        alloc.performRegAllocation();
        return alloc;
    }

}
