package RegAlloc.SSA;


import java.util.Collection;

import utilities.ListOp;
import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;

public class PhiSplitter extends DepthFirstSearch<Instruction> {

    private AllocationInstance ai = null;

    public PhiSplitter(AllocationInstance ai) {
        this.ai = ai;
    }

    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();

        if(inst instanceof PhiInstruction) {

            PhiInstruction phiInst = (PhiInstruction)inst;
            Collection<PhiFunction> phis = phiInst.getPhiFunctions();
            Instruction succPhi = ListOp.first(n.succs()).getData();

            for(DiNode<Instruction> pred : n.preds()) {
                PseudoPhiInstruction ppi = new PseudoPhiInstruction(inst);
                for(PhiFunction phi : phis) {
                    ppi.addDef(phi.getDef());
                    ppi.addUse(phi.getParam(pred.getData()));
                }
                this.ai.cfg.connect(pred.getData(), ppi);
                this.ai.cfg.connect(ppi, succPhi);
            }
            this.ai.cfg.remove(inst);
        }
    }

}
