package RegAlloc.SSA;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

import utilities.ListOp;
import Digraph.DiNode;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.MachineReg;
import RegAlloc.Register;

public class PhiSower {

    private AllocationInstance ai = null;

    private DominanceFrontierBuilder dfb = null;

    private DominanceTreeBuilder dtb = null;

    private HashMap<Instruction, Collection<Register>> scattering = null;

    public PhiSower(AllocationInstance ai, DominanceFrontierBuilder dfb, DominanceTreeBuilder dtb) {
        this.ai = ai;
        this.dfb = dfb;
        this.dtb = dtb;
        this.scattering = new HashMap<Instruction, Collection<Register>>();
    }

    public void placePhiFunctions() {

        for(Register a : this.ai.rF.getRegisters()) {

            if( ! (a instanceof MachineReg) ) {
                Collection<Instruction> w = a.getDefInstructions();

                while( ! w.isEmpty() ) {
                    Instruction n = ListOp.first(w);
                    w.remove(n);

                    if(this.necessaryToInsertPhi(n, a)) {
                        for(Instruction y : this.dfb.getDF(n) ) {

                            if( ! this.scattering.containsKey(y) ) {
                                this.scattering.put(y, new HashSet<Register>());
                            }

                            if( ! this.scattering.get(y).contains(a) ) {
                                this.scattering.get(y).add(a);
                                if( ! y.getDefSet().contains(a) ) {
                                    w.add(y);
                                }
                            }
                        }
                    }
                }
            }
        }

        this.insertPhiFunctions();
    }


    /**
     * Variable a is defined in instruction i. If all the uses of a are inside
     * the dominance frontier of i, it is not necessary to insert phi functions
     * for a.
     */
    private boolean necessaryToInsertPhi(Instruction i, Register a) {
        for(Instruction use : a.getUseInstructions()) {
            if( !this.dtb.getDomain(i).contains(use) )
                return true;
        }
        return false;
    }

    private void insertPhiFunctions() {
        for( Instruction i : this.scattering.keySet() ) {
            DiNode<Instruction> n = this.ai.cfg.getNode(i);
            PhiInstruction phiInst = new PhiInstruction(i);
            for( Register def : this.scattering.get(i) ) {
                PhiFunction phiF = new PhiFunction(def);
                for( DiNode<Instruction> pred : n.preds() ) {
                    phiF.addParam(pred.getData(), def);
                }
                phiInst.addPhi(phiF);
            }
            this.ai.insertBeforeInst(phiInst, i);
            this.dtb.insertBeforeDTInstruction(phiInst, i);
        }
    }


    public String toString() {
        String ans = "";
        for(Instruction inst : this.scattering.keySet()) {
            ans += inst.getName() + ": ";
            for(Register def : this.scattering.get(inst)) {
                ans += def.getName() + " ";
            }
            ans += "\n";
        }
        return ans;
    }
}
