package RegAlloc.SSA;

import RegAlloc.PseudoReg;
import RegAlloc.Register;

public class PhiRegister extends PseudoReg {

    private static int counter = 1;

    private Register originalReg = null;

    private int complement = 0;

    public PhiRegister(Register originalReg) {
        super(String.valueOf(originalReg.getIntegerName()));
        if( originalReg instanceof PseudoReg) {
            this.originalReg = originalReg;
            this.complement = PhiRegister.counter;
            PhiRegister.counter++;
        } else {
            System.err.println("Type inconsistency: attempt to create PhiRegister of type: " + originalReg.getClass().getName());
            System.exit(1);
        }
    }

    public String getName() {
        return originalReg.getName() + "_" + String.valueOf(complement);
    }

}
