package RegAlloc.SSA;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

import RegAlloc.Instruction;
import RegAlloc.Register;

public class PhiInstruction extends Instruction {

    private Instruction origin;

    private HashMap<Register, PhiFunction> phiFunctions = null;

    public void addPhi(PhiFunction phi) {
        this.phiFunctions.put(phi.getDef(), phi);
    }

    public PhiInstruction(Instruction origin) {
        super(String.valueOf(origin.getName()));
        this.phiFunctions = new HashMap<Register, PhiFunction>();
        this.origin = origin;
    }

    public Collection<PhiFunction> getPhiFunctions() {
        LinkedList<PhiFunction> list = new LinkedList<PhiFunction>();
        for(PhiFunction f : this.phiFunctions.values()) {
            list.add(f);
        }
        return list;
    }

    public Instruction getOrigin() {
        return origin;
    }

    public ArrayList<Register> getDefSet() {
        ArrayList<Register> defs = new ArrayList<Register>();
        for(Register reg : this.phiFunctions.keySet()) {
            defs.add(reg);
        }
        return defs;
    }

    public void updateDef(Register newDef, Register oldDef) {
        PhiFunction phiF = this.phiFunctions.get(oldDef);
        phiF.setDef(newDef);
        phiFunctions.remove(oldDef);
        phiFunctions.put(newDef, phiF);
    }

    public String getLabel(boolean showAllocation) {
        String ans = "";

        for(Register def : this.phiFunctions.keySet()) {
            PhiFunction phiF = this.phiFunctions.get(def);
            ans += phiF.toString() + " ";
        }
        

        return "\"" + origin.getName() + ": " + ans + "\"";
    }

}
