package RegAlloc.SSA;

import java.util.HashMap;

import RegAlloc.Instruction;
import RegAlloc.Register;

public class PhiFunction {

    private HashMap<Instruction, Register> parameters = null;

    private Register def = null;

    public PhiFunction(Register def) {
        this.parameters = new HashMap<Instruction, Register>();
        this.def = def;
    }

    public void setDef(Register newDef) {
        this.def = newDef;
    }

    public void updateParam(Instruction i, Register r) {
        if(this.parameters.containsKey(i)) {
            this.parameters.put(i, r);
        }
    }

    public void addParam(Instruction i, Register r) {
        this.parameters.put(i, r);
    }

    public Register getDef() {
        return this.def;
    }

    public Register getParam(Instruction inst) {
        return this.parameters.get(inst);
    }

    public String toString() {
        String uses = "";

        for(Instruction i : this.parameters.keySet()) {
            uses += this.parameters.get(i).getName() + "(" + i.getName() + ") ";
        }

        return this.def.getName() + " <= phi[ " + uses + "]";
    }

}
