package RegAlloc.SSA;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

import Digraph.DiNode;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;

public class DominanceFrontierBuilder {

    private HashMap<Instruction, Collection<Instruction>> df = null;

    private AllocationInstance ai = null;

    private DominanceTreeBuilder dtb = null;

    public DominanceFrontierBuilder(AllocationInstance ai, DominanceTreeBuilder dtb) {
        this.ai = ai;
        this.dtb = dtb;
        this.df = new HashMap<Instruction, Collection<Instruction>>();
    }

    public Collection<Instruction> getDF(Instruction inst) {
        if( ! this.df.containsKey(inst) ) {
            Collection<Instruction> S = new HashSet<Instruction>();
            DiNode<Instruction> n = this.ai.cfg.getNode(inst);
            for( DiNode<Instruction> yNode : n.succs() ) {
                Instruction y = yNode.getData();
                if( ! this.dtb.getIDom(y).equals(inst) ) {
                    S.add(y);
                }
            }
            DiNode<Instruction> dtNode = dtb.getDominanceTree().getNode(inst);
            for( DiNode<Instruction> c : dtNode.succs() ) {
                Collection<Instruction> dtDoms = getDF(c.getData());
                for(Instruction w : dtDoms) {
                    if( (!dtb.dominates(inst, w)) || (inst.equals(w)) ) {
                        S.add(w);
                    }
                }
            }
            this.df.put(inst, S);
        }
        return this.df.get(inst);
    }

    public String toString() {
        String ans = "";
        for(Instruction inst : this.df.keySet()) {
            ans += inst.getName() + ": ";
            for(Instruction dom : this.df.get(inst)) {
                ans += dom.getName() + " ";
            }
            ans += "\n";
        }
        return ans;
    }

}
