package RegAlloc;

/**
 * This class describes a binding between regs. Bindings can be used to
 * describe double memory access, or move instruction, for example. The double
 * memory access is used to describe the situation in which two loads (or to
 * stores) can be replaced by a load-pair (store-pair).
 */
public class RegisterPair {

    private Register    r1 = null;

    private Register    r2 = null;

    private Instruction it = null;

    public RegisterPair(Instruction it, Register r1, Register r2) {
        this.r1 = r1;
        this.r2 = r2;
        this.it = it;
    }

    public String toString() {
        return "Inst " + it.getName() + ": [" + r1.getName() + ", " + r2.getName() + "]";
    }

    public Register getReg1() {
        return this.r1;
    }

    public Register getReg2() {
        return this.r2;
    }

    public Instruction getInstruction() {
        return this.it;
    }

}
