package RegAlloc;

/**
 * This class describes an allocation pair. An Allocation pair is a binding
 * between a pseudo register and a machine register that takes place at a
 * certain instruction.
 */
public class RegisterBinding {

    private PseudoReg   pr = null;

    private MachineReg  mr = null;

    private Instruction it = null;

    public RegisterBinding(Instruction it, PseudoReg pr, MachineReg mr) {
        this.pr = pr;
        this.mr = mr;
        this.it = it;
    }

    public String toString() {
        return "Inst " + it.getName() + ": " + pr.getName() + "(" + mr.getName() + ")";
    }

    public PseudoReg getPseudoReg() {
        return this.pr;
    }

    public MachineReg getMachineReg() {
        return this.mr;
    }

    public Instruction getInstruction() {
        return this.it;
    }

}
