package RegAlloc;

import java.util.Collection;

/**
 * This interface must be implemented by every register allocator.
 * An register allocator is an object that can generate a mapping
 * between temporaries and registers in a way that temporaries whose live
 * ranges interfere are assigned different registers.
 */
public interface RegAllocator {

    /**
     * This method returns a set of informations about the allocation process,
     * such as the number of colors used, the number of spilled registers, the
     * number of coalescing performeds, etc.
     */
    public AllocationData getAllocationData();

    /**
     * This method passes the allocation parameters to the register allocation.
     * @param ai the set of allocation parameters: cfg, frequency of use, etc.
     */
    public void setAllocationParameters(AllocationInstance ai);

    /**
     * This method starts the execution of the allocation algorithm.
     */
    public void performRegAllocation();

    /**
     * This method yields the collection of spilled registers. It must be
     * called after the method <CODE>performRegAllocation()</CODE> is called.
     * @return an collection of nodes of the allocation graph.
     */
    public Collection<Register> getSpilledRegisters();

    /**
     * This method gives back the list of nodes that have been allocated to
     * any register.
     * @return an collection of nodes of the allocation graph.
     */
    public Collection<Register> getAllocatedRegisters();

}
