package RegAlloc.RalfTools;

import java.util.Collection;
import java.util.HashSet;

import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import RegAlloc.Instruction;
import RegAlloc.Register;

public class LivenessAnalysis extends DepthFirstSearch<Instruction> {

    boolean finished = true;

    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();

        // in = uno(use, dif(out, def))
        Collection<Register> in = uno(inst.getUseSet(), dif(inst.getOutSet(), inst.getDefSet()));

        // for all succ, out = union(succ_in)
        Collection<Register> out = new HashSet<Register>();
        Collection<DiNode<Instruction>> succs = n.succs();
        for(DiNode<Instruction> succ : succs) {
            out = uno(out, succ.getData().getInSet());
        }

        // compare against old sets
        Collection<Register> newIn = dif(in, inst.getInSet());
        Collection<Register> newOut = dif(out, inst.getOutSet());
        if(newIn.size() > 0)
            this.finished = false;
        else if(newOut.size() > 0)
            this.finished = false;

        // update the new in and out set
        for(Register reg : newIn)
            inst.addIn(reg);
        for(Register reg : newOut)
            inst.addOut(reg);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void prepareIteration() {
        this.finished = true;
    }

    private Collection<Register> uno(Collection<Register> c1, Collection<Register> c2) {
        Collection<Register> ans = new HashSet<Register>();
        for(Register reg : c1)
            ans.add(reg);
        for(Register reg : c2)
            ans.add(reg);
        return ans;
    }

    private Collection<Register> dif(Collection<Register> c1, Collection<Register> c2) {
        Collection<Register> ans = new HashSet<Register>();
        for(Register reg : c1)
            if(c2.contains(reg) == false)
                ans.add(reg);
        return ans;
    }

    public Collection<Register> cln(Collection<Register> c) {
        Collection<Register> ans = new HashSet<Register>();
        for(Register reg : c)
            ans.add(reg);
        return ans;
    }

}
