package RegAlloc.RalfTools;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;

import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.Register;

public class File_ControlFlowDrawer extends DepthFirstSearch<Instruction> {

    PrintStream out = null;

    private boolean showAllocation = true;

    private AllocationInstance ai = null;

    public File_ControlFlowDrawer(String file_name, AllocationInstance ai) {
        this.ai = ai;
        try {
            this.out = new PrintStream(file_name);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /**
     * This method defines the header of a .dot file. It will return a string
     * giving a short
     * comment about the nature of the graph been described, such as the name
     * of the class and the name of the method. The string will contain a
     * definition of nodes in the graph, e.g.: font size, type of border, etc.
     * @return an object of the String type.
     */ 
    public void printHeaderInformation() {
        this.out.println("digraph XXXXX {\n");
        this.out.println("node [\n");
        this.out.println("    fontname = \"Arial\"");
        this.out.println("    fontsize = \"10\"");
        this.out.println("    shape = \"box\"");
        this.out.println("    style = \"filled\"");
        this.out.println("];\n");
        this.out.println("edge [");
        this.out.println("    fontname = \"Arial\"");
        this.out.println("    fontsize = \"10\"");
        this.out.println("    shape = \"box\"");
        this.out.println("];\n");
    }

    public void showAllocation(boolean showAllocation) {
        this.showAllocation = showAllocation;
    }

    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();

        String instLabel = inst.getLabel(this.showAllocation);
        String color = " [color=orange];";
        if(this.ai != null)
            if(this.ai.iF.isCall(inst))
                color = " [color=cyan];";
        this.out.println(instLabel + color);

        ArrayList<Register> in = inst.getInSet();
        String inN = "";
        for(Register r : in)
            inN += " " + r.getName();

        Collection<DiNode<Instruction>> preds = n.preds();
        for(DiNode<Instruction> pred : preds) {
            this.out.print("    " + pred.getData().getLabel(this.showAllocation) + " -> " + instLabel);
            String label = " [ label = \"" + inN + "\" ];";
            this.out.println(label);
        }
    }


    public void printTailInformation() {
        this.out.println("\n}");
    }

}
