package RegAlloc.RalfTools;

import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.KrParser.FordReader;
import RegAlloc.KrParser.FordReaderImpl;
import RegAlloc.KrParser.InKr;

public class Debugger {

	public static void main(String[] args) {
		if (args.length < 1 || args.length > 2) {
			System.err.println("Syntax: java Debugger file.dat [file.out]");
			System.exit(1);
		}

		// true if the [file.out] argument is present
		boolean outGiven = true;

		// read the .dat file
		AllocationInstance ai = InKr.read(args[0]);

		// read the .out file
		if (args.length == 2) {
			outGiven = true;
			FordReader fr = new FordReaderImpl(args[1], ai);
			Debugger.updateInstructions(fr, ai);
		}

		DFA.cleanControlFlowGraph(ai, "0");
		DFA.performLivenessAnalysis(ai, "0");
		if (outGiven) {
			if(Debugger.searchForBugs(ai)) {
				System.err.println("The set of allocation directives are semantically consistent.");
			} else {
				System.err.println("Error: the set of allocation directives are semantically inconsistent.");				
			}
		}
	}

	public static void updateInstructions(FordReader fr, AllocationInstance ai) {
		BRegFactory brf = new BRegFactory();
		Instruction i = ai.iF.createInstruction("0");
		Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);
		FordSower fs = new FordSower(fr, brf, ai);
		fs.traverse(n);
	}

	public static boolean searchForBugs(AllocationInstance ai) {
		BugHunter bh = new BugHunter(ai);
		Instruction i = ai.iF.createInstruction("0");
		Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);
		bh.traverse(n);
		return bh.isSemanticallyConsistent();
	}

}
