package RegAlloc.RalfTools;

import java.util.ArrayList;

import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.PseudoReg;

/**
 * This class implements several useful analysis in the data flow graph.
 * The best known example of data flow analysis is the so called liveness
 * analysis, that computes the live ranges of each register.
 */
public class DFA {

    public static void performLivenessAnalysis(AllocationInstance ai, String firstInstID) {
        Instruction i = ai.iF.createInstruction(firstInstID);
        Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);

        LivenessAnalysis la = new LivenessAnalysis();
        do {
            la.prepareIteration();
            la.traverse(n);
        } while (! la.isFinished() );
    }


    public static void drawControlFlowGraph(AllocationInstance ai, String firstInstID, String file_name, boolean showAllocation) {
        Instruction i = ai.iF.createInstruction(firstInstID);
        Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);

        File_ControlFlowDrawer dfs = new File_ControlFlowDrawer(file_name, ai);
        dfs.printHeaderInformation();
        dfs.showAllocation(showAllocation);
        dfs.traverse(n);
        dfs.printTailInformation();
    }


    public static void drawControlFlowGraph(AllocationInstance ai, String firstInstID, boolean showAllocation) {
        Instruction i = ai.iF.createInstruction(firstInstID);
        Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);

        ControlFlowDrawer dfs = new ControlFlowDrawer(ai);
        dfs.printHeaderInformation();
        dfs.showAllocation(showAllocation);
        dfs.traverse(n);
        dfs.printTailInformation();
    }


    public static void cleanControlFlowGraph(AllocationInstance ai, String firstInstID) {
        // clean the control flow graph, eg.: remove the in and out set of all
        // the instruction:
        Instruction i = ai.iF.createInstruction(firstInstID);
        Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);
        ControlFlowCleaner cfc = new ControlFlowCleaner();
        cfc.traverse(n);
    }


    public static void computeLivenessSize(AllocationInstance ai, String firstInstID) {
        // reset the size of all the live ranges.
        ArrayList<PseudoReg> pseudoSet = ai.rF.getPseudoRegisters();
        for(PseudoReg pseudo : pseudoSet) {
            pseudo.resetLiveRange();
        }   
        Instruction i = ai.iF.createInstruction(firstInstID);
        Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);
        ComputeLivenessSize cls = new ComputeLivenessSize();
        cls.traverse(n);
    }

}
