package RegAlloc.RalfTools;

import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.KrParser.FordReader;
import RegAlloc.KrParser.FordReaderImpl;
import RegAlloc.KrParser.InKr;

public class ControlFlowViewer {

    public static void main(String [] args) {
        if(args.length < 1 || args.length > 2) {
            System.err.println("Syntax: java ControlFlowViewer file.dat [file.out]");
            System.exit(1);
        }

        // true if the [file.out] argument is present

        // read the .dat file
        AllocationInstance ai = InKr.read(args[0]);

        // read the .out file
        if(args.length == 2) {
            FordReader fr = new FordReaderImpl(args[1], ai);
            updateInstructions(fr, ai);
        }

        DFA.cleanControlFlowGraph(ai, "0");
        DFA.performLivenessAnalysis(ai, "0");
        DFA.drawControlFlowGraph(ai, "0", false);
    }

    public static void updateInstructions(FordReader fr, AllocationInstance ai) {
        BRegFactory brf = new BRegFactory();
        Instruction i = ai.iF.createInstruction("0");
        Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);
        FordSower fs = new FordSower(fr, brf, ai);
        fs.traverse(n);
    }

    public static void searchForBugs(AllocationInstance ai) {
        BugHunter bh = new BugHunter(ai);
        Instruction i = ai.iF.createInstruction("0");
        Digraph.DiNode<Instruction> n = ai.cfg.getNode(i);
        bh.traverse(n);
    }

}
