package RegAlloc.RalfTools;

import java.util.Collection;

import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import Digraph.Digraph;
import RegAlloc.Instruction;

public class ControlFlowShrinker extends DepthFirstSearch<Instruction> {

    Digraph<Instruction> cfg = null;

    public void setGraph(Digraph<Instruction> cfg) {
        this.cfg = cfg;
    }

    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();
        int index = Integer.parseInt(inst.getName());
        if(index % 2 == 1) {
            Collection<DiNode<Instruction>> succs = n.succs();
            for(DiNode<Instruction> succ : succs) {
                succ.removePred(n);
            }

            Collection<DiNode<Instruction>> preds = n.preds();
            for(DiNode<Instruction> pred : preds) {
                pred.removeSucc(n);
                for(DiNode<Instruction> succ : succs) {
                    pred.addSucc(succ);
                    succ.addPred(pred);
                }
            }
            cfg.remove(inst);
        }
    }

}
