package RegAlloc.RalfTools;

import java.util.ArrayList;
import java.util.Collection;

import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.MemoryAccessInstruction;
import RegAlloc.Register;

public class ControlFlowDrawer extends DepthFirstSearch<Instruction> {

    private boolean showAllocation = true;

    private AllocationInstance ai = null;

    public ControlFlowDrawer(AllocationInstance ai) {
        this.ai = ai;
    }

    /**
     * This method defines the header of a .dot file. It will return a string
     * giving a short
     * comment about the nature of the graph been described, such as the name
     * of the class and the name of the method. The string will contain a
     * definition of nodes in the graph, e.g.: font size, type of border, etc.
     * @return an object of the String type.
     */ 
    public void printHeaderInformation() {
        System.out.println("digraph XXXXX {\n");
        System.out.println("node [\n");
        System.out.println("    fontname = \"Arial\"");
        System.out.println("    fontsize = \"10\"");
        System.out.println("    shape = \"box\"");
        System.out.println("];\n");
        System.out.println("edge [");
        System.out.println("    fontname = \"Arial\"");
        System.out.println("    fontsize = \"10\"");
        System.out.println("    shape = \"box\"");
        System.out.println("];\n");
    }

    public void showAllocation(boolean showAllocation) {
        this.showAllocation = showAllocation;
    }

    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();

        String instLabel = inst.getLabel(this.showAllocation);

        String color = "color=orange";
        if(this.ai.iF.isCall(inst))
            color = "color=cyan";

        String style = "style=filled";
        if(inst instanceof MemoryAccessInstruction)
            style = "style=solid";

        String peripheries = "peripheries=1";
        if(this.ai.iF.isMove(inst))
            peripheries = "peripheries=2";

        String nodeDesc = "[ " + color + " " + style + " " + peripheries + " ];";

        System.out.println(instLabel + nodeDesc);

        ArrayList<Register> in = inst.getInSet();
        String inN = "";
        for(Register r : in)
            inN += " " + r.getName();

        Collection<DiNode<Instruction>> preds = n.preds();
        for(DiNode<Instruction> pred : preds) {
            System.out.print("    " + pred.getData().getLabel(this.showAllocation) + " -> " + instLabel);
            String label = " [ label = \"" + inN + "\" ];";
            System.out.println(label);
        }
    }


    public void printTailInformation() {
        System.out.println("\n}");
    }

}
