package RegAlloc.RalfTools;

import java.util.Collection;

import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import RegAlloc.Instruction;
import RegAlloc.Register;

public class ComputeLivenessSize extends DepthFirstSearch<Instruction> {

    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();

        // for all succ, out = union(succ_in)
        Collection<Register> outs = inst.getOutSet();
        for(Register reg : outs) {
            reg.incLiveRange();
        }
    }
}
