package RegAlloc.RalfTools;

import java.util.ArrayList;
import java.util.Collection;

import Graph.Graph;
import Graph.Node;
import RegAlloc.AllocationInstance;
import RegAlloc.MachineReg;
import RegAlloc.Register;
import RegAlloc.ChordalAllocation.GreedyColoringAlgorithm;
import RegAlloc.KrParser.InKr;

public class CFDrawer {

    public static void main(String a[]) {
        if(a.length < 1) {
            System.err.println("Sintaxe: java RegAlloc.CFDrawer file.dat");
            System.exit(1);
        } else {
            AllocationInstance id = InKr.read(a[0]);
            DFA.performLivenessAnalysis(id, "0");
            DFA.drawControlFlowGraph(id, "0", false);
        }
    }

    /**
     * If one wants to apply the greedy coloring algorithm on the interference
     * graph, the following two methods can be used. Notice that this coloring
     * is not optimal. The optimal coloring can be obtained if the graph is
     * chordal. In this case, the greedy algorithm can be feed with the
     * vertices in the simplicial ordering sequence.
     */
    public static void colorGraph(ArrayList<MachineReg> mRegs, Graph<Register> g, int numColors) {
        colorMachineRegisters(mRegs);
        Collection<Node<Register>> nodes = g.getNodes();
        GreedyColoringAlgorithm gca = new GreedyColoringAlgorithm(numColors);
        gca.color(nodes);
    }

    private static void colorMachineRegisters(ArrayList<MachineReg> mRegs) {
        for(int i = 0; i < mRegs.size(); i++)
            mRegs.get(i).setColor(i);
    }

}
