package RegAlloc.RalfTools;

import RegAlloc.MachineReg;
import RegAlloc.Register;

/**
 * A bound register describes a pseudo register that has been allocated to a
 * machine register.
 */
public class BoundReg extends Register {

    private Register pr = null;

    private MachineReg mr = null;

    public BoundReg(Register pr, MachineReg mr) {
        super(String.valueOf(pr.getIntegerName()));
        this.pr = pr;
        this.mr = mr;
    }

    public Register getPseudoReg() {
        return this.pr;
    }

    public MachineReg getMachineReg() {
        return this.mr;
    }

    public String getName() {
        return this.pr.getName() + "(" + this.mr.getName() + ")";
    }

    public int getIntegerName() {
        return this.pr.getIntegerName();
    }

    public boolean isPreColoredRegister() {
        return pr.isPreColoredRegister();
    }

    public String toString() {
        return this.pr.getName() + "(" + this.mr.getName() + ")";
    }

    public Register getAllocationDestiny() {
        return this.mr;
    }
}
