package RegAlloc.RalfTools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

import RegAlloc.MachineReg;
import RegAlloc.Register;
import RegAlloc.RegisterFactory;

/**
 * The register factory is extends the basic factory to create bound registers.
 */
public class BRegFactory extends RegisterFactory {

    private HashMap<Register, Collection<BoundReg>> boundRegs = new HashMap<Register, Collection<BoundReg>>();
    private int numBoundRegs = 0;

    /**
     * This method generates a new bound register. If the register has been
     * already created, then the old instance will be returned. Otherwise, a new
     * object will be created.
     * @param id the name of the new register.
     * @return an object of the <CODE>MachineReg</CODE> type.
     */
    public BoundReg createBoundRegister(Register pr, MachineReg mr) {

        Collection<BoundReg> bindings = null;

        if(this.boundRegs.containsKey(pr)) {
            bindings = this.boundRegs.get(pr);
        } else {
            bindings = new HashSet<BoundReg>();
            this.boundRegs.put(pr, bindings);
        }

        for(BoundReg br : bindings)
            if(br.getMachineReg().equals(mr))
                return br;

        BoundReg br = new BoundReg(pr, mr);
        bindings.add(br);
        this.numBoundRegs++;
        return br;

    }


    /**
     * Returns a list of the caller save registers.
     */
    public ArrayList<BoundReg> getBoundRegisters() {
        ArrayList<BoundReg> list = new ArrayList<BoundReg>(this.numBoundRegs);
        Collection<Collection<BoundReg>> values = this.boundRegs.values();
        for(Collection<BoundReg> c : values) {
            for(BoundReg br : c)
                list.add(br);
        }
        return list;
    }


    /**
     * This method informs the number of machine registers available to solve
     * the register allocation problem.
     */
    public int getNumMachineRegisters() {
        return this.numBoundRegs++;
    }


    public String toString() {
        String ans = "";
        ArrayList<BoundReg> list = this.getBoundRegisters();
        for(BoundReg br : list) {
            ans += br.toString() + "\n";
        }
        return ans;
    }

}
