package RegAlloc;

import java.util.Collection;

/**
 * This class represents a pseudo register in the allocation process.
 * Pseudo-registers are used to denote temporaries in the intermediate 
 * representation. Because the number of pseudo-registers is normally far
 * bigger than the number of machine register, a register allocation algorithm
 * is necessary to determinate the real location of each value that is stored
 * in a pseudo register.
 */
public class PseudoReg extends Register {

    public PseudoReg(String id) {
        super(id);
    }

    public String getName() {
        return 't' + super.getName();
    }

    public boolean isPreColoredRegister() {
        return false;
    }

    /**
     * This method prints, for each instruction that defines this register, a
     * string such as <CODE>inst pseudo color</CODE>. It is used to generate
     * some output in accordance with Krishna's specification.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String defOutput() {
        int pseudo = this.getIntegerName();
        Register finalLocation = this.getAllocationDestiny();
        int location = finalLocation.getIntegerName();
        String output = "";
        Collection<Instruction> c = this.getDefInstructions();
        for(Instruction inst : c)
            output += inst.getName() + " " + pseudo + " " + location + '\n';
        return output;
    }

    /**
     * This method prints the uses of this register according to Krhisna's
     * specification. For example, if this is pseudo 4, and it is loaded in
     * register 8 in instruction 54, where it is used, the following output will
     * be given: <CODE>54 4 8</CODE>.
     */
    public String PsR() {
        int pseudo = this.getIntegerName();
        Register finalLocation = this.getAllocationDestiny();
        int location = finalLocation.getIntegerName();
        String output = "";
        Collection<Instruction> c = this.getUseInstructions();
        for(Instruction inst : c)
            output += inst.getName() + " " + pseudo + " " + location + '\n';
        return output;
    }

}
