package RegAlloc.Naive;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import utilities.Useful;
import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.MachineReg;
import RegAlloc.PseudoReg;
import RegAlloc.Register;
import RegAlloc.KrParser.OutputLine;

public class NaiveCodeGenerator extends DepthFirstSearch<Instruction> {

    private AllocationInstance ai = null;

    private MachineReg loadReg1 = null;

    private MachineReg loadReg2 = null;

    private MachineReg loadReg3 = null;

    private MachineReg loadReg4 = null;

    private MachineReg storeReg = null;

    private List<OutputLine> stores = new ArrayList<OutputLine>();

    private List<OutputLine> loads = new ArrayList<OutputLine>();

    private List<OutputLine> xdefs = new ArrayList<OutputLine>();

    private List<OutputLine> psr = new ArrayList<OutputLine>();

    public NaiveCodeGenerator(AllocationInstance ai) {
        this.ai = ai;
        this.loadReg1 = this.ai.rF.createMachineRegister("5");
        this.loadReg2 = this.ai.rF.createMachineRegister("6");
        this.loadReg3 = this.ai.rF.createMachineRegister("7");
        this.loadReg4 = this.ai.rF.createMachineRegister("8");
        this.storeReg = this.ai.rF.createMachineRegister("4");
    }

    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();

        ArrayList<Register> def = inst.getDefSet();
        for(Register reg : def) {
            if( !(reg instanceof MachineReg) ) {
                OutputLine ol = new OutputLine(inst.getName() + " " + reg.getIntegerName() + " " + storeReg.getIntegerName());
                this.stores.add(ol);
                this.xdefs.add(ol);
            }
        }

        ArrayList<Register> use = inst.getUseSet();
        int counter = 0;
        MachineReg auxReg = null;
        for(Register reg : use) {
            if( !(reg instanceof MachineReg) ) {
                switch(counter) {
                    case 0:
                        auxReg = this.loadReg1;
                        counter++;
                    break;
                    case 1:
                        auxReg = this.loadReg2;
                        counter++;
                    break;
                    case 2:
                        auxReg = this.loadReg3;
                        counter++;
                    break;
                    case 3:
                        auxReg = this.loadReg4;
                        counter++;
                    break;
                    default:
                        System.err.println("Error: " + inst + " has more than four uses.");
                        System.exit(1);
                    break;
                }
                String instName = inst.getName();
                String tempName = String.valueOf(reg.getIntegerName());
                String regName = String.valueOf(auxReg.getIntegerName());
                OutputLine ol = new OutputLine(instName + " " + tempName + " " + regName);
                this.loads.add(ol);
                this.psr.add(ol);
            }
        }
    }


    private void printOrderedList(List<OutputLine> list) {
        List<OutputLine> sorted = Useful.sort(list);
        for(int i = 0; i < sorted.size(); i++) {
            OutputLine ol = sorted.get(i);
            System.out.println(ol.inst + " " + ol.pseudo + " " + ol.reg);
        }
    }

    public void printLSM() {
        ListIterator<PseudoReg> iter = this.ai.lsm.listIterator();
        while(iter.hasNext()) {
            PseudoReg reg = iter.next();
            System.out.println(reg.getIntegerName() + " " + reg.getIntegerName());
        }
    }


    public void printOutput() {
        System.out.println("xdef:=");
        printOrderedList(this.xdefs);
        System.out.println(";");

        System.out.println("PsR:=");
        printOrderedList(this.psr);
        System.out.println(";");

        System.out.println("spLoad:=");
        printOrderedList(this.loads);
        System.out.println(";");

        System.out.println("loadPair:=");
        System.out.println(";");

        System.out.println("spStore:=");
        printOrderedList(this.stores);
        System.out.println(";");

        System.out.println("storePair:=");
        System.out.println(";");

        System.out.println("f:=");
        this.printLSM();
        System.out.println(";");

        System.out.println("inverseLoad:=");
        System.out.println(";");

        System.out.println("inverseStore:=");
        System.out.println(";");

        System.out.println("freeRegs:=");
        System.out.println(";");

        System.out.println("RegMoves:=");
        System.out.println(";");
    }
}
