package RegAlloc.Naive;

import java.io.IOException;
import java.util.Collection;

import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.Register;
import RegAlloc.KrParser.InKr;

/**
 * Simplest RegAlloc ever built. It generates a load for each definition, and
 * a store for each use.
 */
public class NaiveAllocator {

    private AllocationInstance ai = null;

    private NaiveCodeGenerator ncg = null;

    /**
     * This method starts the execution of the allocation algorithm.
     */
    public void performRegAllocation() {
        this.ncg = new NaiveCodeGenerator(this.ai);
        Instruction i = this.ai.iF.createInstruction("0");
        Digraph.DiNode<Instruction> n = this.ai.cfg.getNode(i);
        ncg.traverse(n);
    }

    public void setAllocationParameters(AllocationInstance ai) {
        this.ai = ai;
    }

    /**
     * This method yields the collection of spilled registers. It must be
     * called after the method <CODE>performRegAllocation()</CODE> is called.
     * @return an collection of nodes of the allocation graph.
     */
    public Collection<Register> getSpilledRegisters() {
        return null;
    }

    /**
     * This method gives back the list of nodes that have been allocated to
     * any register.
     * @return an collection of nodes of the allocation graph.
     */
    public Collection<Register> getAllocatedRegisters() {
        return null;
    }

    public void printOutput() {
        this.ncg.printOutput();
    }


    public static void main(String a[]) throws IOException {
        if(a.length < 1) {
            System.err.println("java NaiveAllocator in.dat");
            System.exit(1);
        } else {
            System.err.println("Running the naive code allocator");
            AllocationInstance ai = InKr.read(a[0]);
            NaiveAllocator alloc = new NaiveAllocator();
            alloc.setAllocationParameters(ai);
            alloc.performRegAllocation();
            alloc.printOutput();
        }
    }
}
