package RegAlloc;

import java.util.Collection;

/**
 * This class represents a memory access register in the allocation process.
 * Memory access registers are created as surrogates for spilled registers,
 * as results of loads and stores places after register eviction.
 * Normally these registers have very short and continuous live ranges.
 */
public class MemoryAccessRegister extends PseudoReg {

    private static int counter = 100;

    private Register originalReg = null;

    private int complement = 0;

    public MemoryAccessRegister(Register pr) {
        super(String.valueOf(pr.getIntegerName()));
        this.complement = MemoryAccessRegister.counter++;
        this.originalReg = pr;
    }

    public String getName() {
        return super.getName() + String.valueOf(complement);
    }

    public Register getOriginalReg() {
        return this.originalReg;
    }

    /**
     * This method prints, for each instruction that defines this register, a
     * string such as <CODE>inst pseudo color</CODE>. It is used to generate
     * some output in accordance with Krishna's specification. In contrat with
     * the same method implemented in the class <CODE>PseudoReg</CODE>, this
     * method uses the identifier of the register that gave origin to this
     * memory access register. For example, if t_11 has been created as a
     * surrogate of t_1, then t_1 will be printed, instead of t_11.
     * Notice that in this implementation there is two different types of
     * instructions: basic instructions, and memory access instructions.
     * Definitions must be generated for basic instructions only. Definitions
     * in memory access instructions will result in loads been output.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String defOutput() {
        int pseudo = this.originalReg.getIntegerName();
        Register finalLocation = this.getAllocationDestiny();
        int location = finalLocation.getIntegerName();
        String output = "";
        Collection<Instruction> c = this.getDefInstructions();
        for(Instruction inst : c)
            if(! (inst instanceof MemoryAccessInstruction))
                output += inst.getName() + " " + pseudo + " " + location + '\n';
        return output;
    }

    /**
     * This method prints the uses of this register according to Krhisna's
     * specification. For example, if this is pseudo 4, and it is loaded in
     * register 8 in instruction 54, where it is used, the following output will
     * be given: <CODE>54 4 8</CODE>.
     */
    public String PsR() {
        int pseudo = this.originalReg.getIntegerName();
        Register finalLocation = this.getAllocationDestiny();
        int location = finalLocation.getIntegerName();
        String output = "";
        Collection<Instruction> c = this.getUseInstructions();
        for(Instruction inst : c)
            if(! (inst instanceof MemoryAccessInstruction))
                output += inst.getName() + " " + pseudo + " " + location + '\n';
        return output;
    }
}
