package RegAlloc;

import java.util.ArrayList;

/**
 * This class is used in order to represent the loads and stores that are
 * inserted to the control flow due to spills.
 */
public class MemoryAccessInstruction extends Instruction {

    private static int counter = 1048576;

    /**
     * The origin instruction contains the register that has been spilled, and
     * that caused the creation of the auxiliar instruction.
     */
    private Instruction origin;

    public Instruction getOrigin() {
        return origin;
    }

    public MemoryAccessInstruction(String id, Instruction origin) {
        super(id + String.valueOf(counter));
        MemoryAccessInstruction.counter++;
        this.origin = origin;
    }

    public String toString() {
        final int DISP = 16;
        String d = "", u = "", n = super.getName();

        for(Register r : super.getDefSet())
            d += " " + r.getName();
        for(int j = d.length(); j < DISP/2; j++)
            d += " ";

        for(Register r : super.getUseSet())
            u += " " + r.getName();
        for(int j = u.length(); j < DISP; j++)
            u += " ";

        for(int j = n.length(); j < DISP/4; j++)
            n += " ";

        return n + " |" + d + " |" + u + " points to " + origin.getName();
    }


    public String getLabel(boolean showAllocation) {
        ArrayList<Register> def = this.getDefSet();
        String defN = "";
        for(Register r : def) {
            defN += " " + r.getName();
            if(!r.isPreColoredRegister() && showAllocation)
                defN += "(" + r.getAllocationDestiny().getName() + ")";
        }

        ArrayList<Register> use = this.getUseSet();
        String useN = "";
        for(Register r : use) {
            useN += " " + r.getName();
            if(!r.isPreColoredRegister() && showAllocation)
                useN += "(" + r.getAllocationDestiny().getName() + ")";
        }

        ArrayList<Register> in = this.getInSet();
        String inN = "";
        for(Register r : in)
            inN += " " + r.getName();
        return "\"" + this.origin.getName() + " : " + defN + " <= " + useN + "\"";
    }


    /**
     * This method is used to avoid the use of type casts. In this way, an
     * object whose dynamic type is a Memory Access, but whose static type is a
     * simple instruction can be converted to memory access during execution
     * time.
     */
    public MemoryAccessInstruction getMemoryAccessEqv() {
        return this;
    }

}
