package RegAlloc;


/**
 * This class represents a machine register in the allocation process. The
 * machine register exist in limited number; thus, the normally the same
 * machine register holds the value of several different temporaries.
 */
public class MachineReg extends Register {

    public MachineReg(String id) {
        super(id);
        this.setColor(-1);
        this.setAllocationDestiny(this);
    }

    public String getName() {
        return 'r' + super.getName();
    }

    public void setAllocationDestiny(Register reg) {
        if(!reg.equals(this))
            System.err.println("Error: attempt to allocate " + this.getName() + " in " + reg.getName());
        else
            super.setAllocationDestiny(reg);
    }

    public boolean isPreColoredRegister() {
        return true;
    }

}
