package RegAlloc.KrParser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;


/**
 * This class is a parser for the files generated by Krishna's framework. The
 * information read will be stored in an structure of the type
 * <CODE>AllocationInstance</CODE>. This structure contains the control flow
 * graph, and the interference graph generated.
 */
public class StatsParser  {

    public static void read(String fileName) {

        int nInsts = 0;
        int nPseudos = 0;
        int stores = 0;
        int loads = 0;
        int calleeSaveReg = 0;

        try {
            BufferedReader fileReader = new BufferedReader(new FileReader(fileName));

            while(true) {
                String line = fileReader.readLine();
                if(line.startsWith("* ")) {
                    System.out.println("nInsts = " + nInsts);
                    System.out.println("nPseudos = " + nPseudos);
                    System.out.println("Stores = " + stores);
                    System.out.println("Loads = " + loads);
                    System.out.println("CalleSaveReg = " + calleeSaveReg);
                    System.out.println(line);
                    nInsts = 0;
                    nPseudos = 0;
                    stores = 0;
                    loads = 0;
                    calleeSaveReg = 0;
                } else if(line.startsWith("nInsts")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    nInsts += Integer.parseInt(st.nextToken());
                } else if(line.startsWith("nPseudos")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    nPseudos += Integer.parseInt(st.nextToken());
                } else if(line.startsWith("Stores")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    stores += Integer.parseInt(st.nextToken());
                } else if(line.startsWith("Loads")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    loads += Integer.parseInt(st.nextToken());
                } else if(line.startsWith("CalleeSaveReg")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    calleeSaveReg += Integer.parseInt(st.nextToken());
                }
            }
        } catch (Exception e) {
            System.out.println("nInsts = " + nInsts);
            System.out.println("nPseudos = " + nPseudos);
            System.out.println("Stores = " + stores);
            System.out.println("Loads = " + loads);
            System.out.println("CalleSaveReg = " + calleeSaveReg);
        }
    }

    public static void main(String a[]) {
        if(a.length < 1) {
            System.err.println("Sintaxe: java StatsParser file.stats");
            System.exit(1);
        } else {
            StatsParser.read(a[0]);
        }
    }

}
