package RegAlloc.KrParser;

import java.util.StringTokenizer;

import RegAlloc.Instruction;
import RegAlloc.Register;

public class OutputLine implements Comparable<OutputLine> {

    public int reg = -1;
    public int inst = -1;
    public int pseudo = -1;

    public OutputLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        this.inst = Integer.parseInt(st.nextToken());
        this.pseudo = Integer.parseInt(st.nextToken());
        this.reg = Integer.parseInt(st.nextToken());
    }

    public OutputLine(int inst, int pseudo, int reg) {
        this.inst = inst;
        this.pseudo = pseudo;
        this.reg = reg;
    }

    public int compareTo(OutputLine o) {
        return this.inst - o.inst;
    }

/*
    public int hashCode() {
        return (this.pseudo + 1) * (this.reg + 2) * (this.inst + 3);
    }

    public boolean equals(Object o) {
        return o.hashCode() == this.hashCode();
    }
*/

    public String toString() {
        return this.inst + " " + this.pseudo + " " + this.reg;
    }

    public static OutputLine buildOutputLine(Instruction inst, Register reg) {
        String instName = inst.getName();
        String pseudoName = String.valueOf(reg.getIntegerName());
        String machineRegName = String.valueOf(reg.getAllocationDestiny().getIntegerName());
        return new OutputLine(instName + " " + pseudoName + " " + machineRegName);
    }

    public static OutputLine buildOutputLine(Instruction inst, Register pseudoReg, Register machineReg) {
        String instName = inst.getName();
        String pseudoName = String.valueOf(pseudoReg.getIntegerName());
        String machineRegName = String.valueOf(machineReg.getIntegerName());
        return new OutputLine(instName + " " + pseudoName + " " + machineRegName);
    }

}
