package RegAlloc.KrParser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

import utilities.Useful;
import Digraph.DiNode;
import Digraph.Digraph;
import RegAlloc.AllocationInstance;
import RegAlloc.Instruction;
import RegAlloc.PseudoReg;
import RegAlloc.RegAllocator;
import RegAlloc.Register;

/**
 * This class generates the output for Krishna's framework. The output will
 * be generated from the data provided in two data structures: and
 * <CODE>AllocationInstance</CODE> and the result of the register allocation,
 * a <CODE>RegAllocator</CODE> object. The main method is <CODE>write</CODE>,
 * but this class uses some auxiliary routines, mostly because Krishna asks
 * to order the output by the instruction number.
 */
public class OutKr {

    private AllocationInstance kd = null;

    private RegAllocator ra = null;

    public OutKr(RegAllocator ra, AllocationInstance kd) {
        this.kd = kd;
        this.ra = ra;
    }

    private class PsRExtractor implements LineExtractor {

        public void extractLine(Register r, List<OutputLine> list) {
            String k = r.PsR();
            StringTokenizer st1 = new StringTokenizer(k, "\n");
            while(st1.hasMoreTokens()) {
                String tk = st1.nextToken();
                list.add(new OutputLine(tk));
            }
        }

        public void extractLine(Digraph<Instruction> d, List<OutputLine> list){}

    }

    private class DefOutputExtractor implements LineExtractor {

        public void extractLine(Register r, List<OutputLine> list) {
            String k = r.defOutput();
            StringTokenizer st1 = new StringTokenizer(k, "\n");
            while(st1.hasMoreTokens()) {
                String tk = st1.nextToken();
                list.add(new OutputLine(tk));
            }
        }

        public void extractLine(Digraph<Instruction> d, List<OutputLine> list){}

    }

    private class spLoadExtractor implements LineExtractor {

        public void extractLine(Register r, List<OutputLine> list) {
        }

        public void extractLine(Digraph<Instruction> d, List<OutputLine> list) {
            LoadPrinter ld = new LoadPrinter(list, kd.rF, kd.iF);
            Instruction i = kd.iF.createInstruction("0");
            DiNode<Instruction> n = d.getNode(i);
            ld.traverse(n);
        }

    }

    private class spStoreExtractor implements LineExtractor {

        public void extractLine(Register r, List<OutputLine> list) {
        }

        public void extractLine(Digraph<Instruction> d, List<OutputLine> list) {
            StorePrinter sp = new StorePrinter(list, kd.rF, kd.iF);
            Instruction i = kd.iF.createInstruction("0");
            DiNode<Instruction> n = d.getNode(i);
            sp.traverse(n);
        }

    }


    public void printSpStore(spStoreExtractor ext) {
        ArrayList<OutputLine> list = new ArrayList<OutputLine>();
        ext.extractLine(this.kd.cfg, list);
        List<OutputLine> sorted = Useful.sort(list);
        for(int i = 0; i < sorted.size(); i++) {
            OutputLine ol = sorted.get(i);
            System.out.println(ol.inst + " " + ol.pseudo + " " + ol.reg);
        }
    }


    public void printSpLoad(spLoadExtractor ext) {
        ArrayList<OutputLine> list = new ArrayList<OutputLine>();
        ext.extractLine(this.kd.cfg, list);
        List<OutputLine> sorted = Useful.sort(list);
        for(int i = 0; i < sorted.size(); i++) {
            OutputLine ol = sorted.get(i);
            System.out.println(ol.inst + " " + ol.pseudo + " " + ol.reg);
        }
    }


    public void printOrderedList(LineExtractor ext, Collection<Register> c1) {
        ArrayList<OutputLine> list = new ArrayList<OutputLine>();
        for(Register r : c1)
            ext.extractLine(r, list);
        List<OutputLine> sorted = Useful.sort(list);
        for(int i = 0; i < sorted.size(); i++) {
            OutputLine ol = sorted.get(i);
            System.out.println(ol.inst + " " + ol.pseudo + " " + ol.reg);
        }
    }

    public void printLSM() {
        ListIterator<PseudoReg> iter = this.kd.lsm.listIterator();
        while(iter.hasNext()) {
            PseudoReg reg = iter.next();
            System.out.println(reg.getIntegerName() + " " + reg.getIntegerName());
        }
    }


    public void write() {
        Collection<Register> ar = ra.getAllocatedRegisters();

        System.out.println("xdef:=");
        DefOutputExtractor doe = new DefOutputExtractor();
        this.printOrderedList(doe, ar);
        System.out.println(";");

        System.out.println("PsR:=");
        PsRExtractor psr = new PsRExtractor();
        this.printOrderedList(psr, ar);
        System.out.println(";");

        System.out.println("spLoad:=");
        spLoadExtractor spL = new spLoadExtractor();
        this.printSpLoad(spL);
        System.out.println(";");

        System.out.println("loadPair:=");
        System.out.println(";");

        System.out.println("spStore:=");
        spStoreExtractor spS = new spStoreExtractor();
        this.printSpStore(spS);
        System.out.println(";");

        System.out.println("storePair:=");
        System.out.println(";");

        System.out.println("f:=");
        this.printLSM();
        System.out.println(";");

        System.out.println("inverseLoad:=");
        System.out.println(";");

        System.out.println("inverseStore:=");
        System.out.println(";");

        System.out.println("freeRegs:=");
        System.out.println(";");

        System.out.println("RegMoves:=");
        System.out.println(";");
    }

}
