package RegAlloc.KrParser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import Digraph.DepthFirstSearch;
import Digraph.DiNode;
import RegAlloc.Instruction;
import RegAlloc.InstructionFactory;
import RegAlloc.MachineReg;
import RegAlloc.MemoryAccessInstruction;
import RegAlloc.Register;
import RegAlloc.RegisterFactory;

public class LoadPrinter extends DepthFirstSearch<Instruction> {

    private List<OutputLine> list = null;

    private RegisterFactory rF = null;

    private InstructionFactory iF = null;


    public LoadPrinter(List<OutputLine> list, RegisterFactory rF, InstructionFactory iF) {
        this.rF = rF;
        this.iF = iF;
        this.list = list;
    }


    public void visit(DiNode<Instruction> n) {
        Instruction inst = n.getData();
        if(this.iF.isCall(inst)) {
            ArrayList<Register> liveList = inst.getOutSet();
            for(Register reg : liveList) {
                if(this.mustBeSaved(reg)) {
                    Register regLoc = reg.getAllocationDestiny();
                    Collection<DiNode<Instruction>> succs = n.succs();
                    for(DiNode<Instruction> succ : succs) {
                        Instruction loadLoc = succ.getData().getOrigin();
                        if(!this.iF.isCall(succ.getData())) {
                            OutputLine ol = new OutputLine(loadLoc.getName() + " " + reg.getIntegerName() + " " + regLoc.getIntegerName());
                            this.list.add(ol);
                        }
                    }
                }
            }
        } else if(inst instanceof MemoryAccessInstruction) {
            MemoryAccessInstruction mai = inst.getMemoryAccessEqv();
            Instruction originInst = mai.getOrigin();
            int index = Integer.parseInt(originInst.getName());
            ArrayList<Register> defs = mai.getDefSet();
            for(Register reg : defs) {
                int regLocIn = reg.getAllocationDestiny().getIntegerName();
                int originRegIn = this.rF.getOriginalRegister(reg).getIntegerName();
                OutputLine ol = new OutputLine(index + " " + originRegIn + " " + regLocIn);
                this.list.add(ol);
            }
        }
    }


    /**
     * This method determines if the pseudo register must be saved before call
     * instructions. A Pseudo must be saved if it is stored in a caller saved
     * register. Notice that this rule does not apply to machine registers.
     */
    private boolean mustBeSaved(Register reg) {
        if(reg.isPreColoredRegister())
            return false;
        else {
            ArrayList<MachineReg> callerSaveRegs = rF.getCallerSaveRegisters();
            if(callerSaveRegs.contains(reg.getAllocationDestiny()))
                return true;
            else
                return false;
        }
    }

    public List getStoreList() {
        return this.list;
    }

}
