package RegAlloc.ChordalAllocation;

import RegAlloc.Register;

/**
 * This class is used only to encapsulate the pair of registers involved in a move
 * instruction. If possible, such registers may be colored with the same color
 * in order to propagate copies of variables.
 */
public class MovePair {
    public Register src = null;
    public Register dst = null;

    public MovePair(Register src, Register dst) {
        this.src = src;
        this.dst = dst;
    }

    public boolean equals(Object o) {
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.src.hashCode() ^ this.dst.hashCode();
    }

    public String toString() {
        return "Move from " + src + " to " + dst;
    }
}
