package RegAlloc.ChordalAllocation;

import java.util.Collection;
import java.util.ListIterator;

import Graph.Node;
import RegAlloc.Register;

/**
 * This class implements a greedy coloring algorithm. The algorithm keeps the
 * colors ordered according to a certain criterion, and attempts to color each
 * node with the first available color. In this representation, colors are
 * integer numbers.
 */
public class GreedyColoringAlgorithm {

    private int availableColors[] = null;

    public GreedyColoringAlgorithm(int numColors) {
        this.availableColors = new int[numColors];
    }

    public int color(Collection<Node<Register>> c) {
        int maxColor = -1;
        for(Node<Register> n : c) {
            int aux = color(n);
            if(aux > maxColor)
                maxColor = aux;
        }
        return maxColor;
    }

    public int color(ListIterator<Node<Register>> iter) {
        int maxColor = -1;
        while(iter.hasNext()) {
            Node<Register> n = iter.next();
            int aux = color(n);
            if(aux > maxColor)
                maxColor = aux;
        }
        return maxColor;
    }

    private int color(Node<Register> n) {
        for(int i = 0; i < this.availableColors.length; i++)
            this.availableColors[i] = -1;

        // find an available color.
        for(Node<Register> succ : n.neighbors()) {
            Register sKey = succ.getData();
            if(sKey.getColor() >= 0) {
                this.availableColors[sKey.getColor()] = 1;
            }
        }

        for(int i = 0; i < this.availableColors.length; i++)
            if(this.availableColors[i] == -1) {
                n.getData().setColor(i);
                break;
            }
        return n.getData().getColor();
    }

/*
    private int color(Node<Register> n) {
System.err.print(n.getData() + ": ");
        for(int i = 0; i < this.availableColors.length; i++)
            this.availableColors[i] = -1;

        // find an available color.
        for(Node<Register> succ : n.neighbors()) {
            Register sKey = succ.getData();
            if(sKey.getColor() >= 0) {
                this.availableColors[sKey.getColor()] = 1;
System.err.print(" " + sKey.getName() + "(" + sKey.getColor() + ") ");
            }
        }

        for(int i = 0; i < this.availableColors.length; i++)
            if(this.availableColors[i] == -1) {
                n.getData().setColor(i);
                break;
            }
if(n.getData().getColor() < 0)
System.err.println("\nFailed to color: " + n.getData());
System.err.println();
        return n.getData().getColor();
    }
 */

}
