package RegAlloc.ChordalAllocation;

import java.util.Collection;
import java.util.HashSet;

import Graph.Node;
import RegAlloc.Register;

/**
 * This class is used to map a node to all the cliques in which the node is
 * present. This is necessary in order to spill registers that are present
 * in the intersection of cliques. Generally, if registers in the intersection
 * of several cliques are spilled, the number of spills will be smaller.
 * The class holds a reference to the node, and a collection of collections.
 * Each of these collections is a list of other nodes that constitute a
 * clique.
 */
public class CliquesPerNode extends HashSet<Collection<Node<Register>>> {

    static final long serialVersionUID = 50;
    private Node<Register> node = null;

    public CliquesPerNode(Node<Register> node) {
        super();
        this.node = node;
    }

    public Node<Register> getNode() {
        return this.node;
    }

    public String toString() {
        String s = node.getData().toString();
        for(Collection<Node<Register>> h : this)
            s += " " + cliqueToString(h);
        return s;
    }

    public String cliqueToString(Collection<Node<Register>> h) {
        String s = "{";
        for(Node<Register> n : h)
            s += " " + n.getData().toString();
        return s + "}\n";
    }

}
