package RegAlloc;

/**
 * This class represents a node to be used in the Maximum Cardinality Search
 * algorithm. It contains an integer field that determines its cardinality.
 */

public class CardNode {

    public static final int REMOVED = 1;
    public static final int IN_LIST = 2;
    public static final int UNVISITED = 4;

    private int cardinality = 0;

    private int status = UNVISITED;

    /**
     * The constructor methods are made non-public because the implementation
     * of nodes is restricted to the graph library.
     */
    public CardNode() {
        this.status = UNVISITED;
        this.cardinality = 0;
        this.color = INITIAL_COLOR;
    }


    /**
     * This method initializes the internal state of the node.
     */
    public void resetCardinality() {
        this.status = UNVISITED;
        this.cardinality = 0;
        this.color = INITIAL_COLOR;
    }


    /**
     * Determines the status of the node. The possible status are:
     * <CODE>IN_LIST</CODE><BR>
     * <CODE>UNVISITED</CODE><BR>
     * <CODE>REMOVED</CODE><BR>
     * @param status the status of this node.
     */
    public void setStatus(int status) {
        if(status == REMOVED)
            this.status = REMOVED;
        else if(status == IN_LIST)
            this.status = IN_LIST;
        else
            this.status = UNVISITED;
    }


    /**
     * Informs the status of the node.
     * @return an integer value;
     */
    public int getStatus() {
        return this.status;
    }


    /**
     * This method increases the cardinality of the node by one unit.
     */
    public void incCardinality() {
        this.cardinality++;
    }

    /**
     * This method informs the cardinality of this node.
     * @return a data of the <CODE>int</CODE> type.
     */
    public int getCardinality() {
        return this.cardinality;
    }


   /*
    * The following operations are used to color the node:
    */
    private static final int INITIAL_COLOR = -1;

    private int color = INITIAL_COLOR;


    /**
     * Sets the color of the node back to its original value. The original
     * value is the one that characterizes the node in the moment of its
     * creation.
     */
    public void resetColor() {
        this.color = INITIAL_COLOR;
    }


    /**
     * Defines the color of this key.
     * @param color the new color.
     */
    public void setColor(int color) {
        this.color = color;
    }


    /**
     * Returns the current color of this key.
     * @return a int value represent the color of the key.
     */
    public int getColor() {
        return this.color;
    }


    /**
     * Textual representation of the node.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String toString() {
        String s = "";
        if(this.color < 0)
            s = "*" + s;
        return s;
    }


    /**
     * Textual representation of the node. Includes also the state of the node
     * regarding the chordal test.
     * @return an object of the <CODE>String</CODE> type.
     */
    public String completeToString() {
        String sts = null;
        switch(status) {
            case REMOVED: sts = " REMOVED"; break;
            case IN_LIST: sts = " IN_LIST"; break;
            case UNVISITED: sts = " UNVISITED"; break;
            default: sts = " Unknow status";
        }
        return "(" + this.color + ")" + sts;
    }

}
