package RegAlloc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

import Digraph.DiNode;
import Digraph.Digraph;
import Graph.Graph;
import Graph.SimpleGraph;
import Graph.SimpleNodeFc;

/**
 * This class contains all the data read from the parser of Krishna's input.
 */
public class AllocationInstance {

    public Digraph<Instruction> cfg = null;

    public Graph<Register> ig = null;

    public RegisterFactory rF = null;

    public InstructionFactory iF = null;

    public LinkedList<PseudoReg> lsm = null;


    /**
     * This method builds the interference graph from the liveness information
     * stored in the control flow graph.
     */
    public void buildInterferenceGraph() {
        this.ig = new SimpleGraph<Register>();
        this.ig.setNodeFactory(new SimpleNodeFc<Register>());

        // Add all the pseudo registers to the graph.
        ArrayList<PseudoReg> pseudoSet = this.rF.getPseudoRegisters();
        for(PseudoReg pseudo : pseudoSet)
            this.ig.newNode(pseudo);

        // set the interferences between simultaneously alive registers
        Collection<DiNode<Instruction>> insts = this.cfg.getNodes();
        for(DiNode<Instruction> nInst : insts) {
            ArrayList<Register> ll = nInst.getData().getInSet();
            for(int j = 0; j < ll.size(); j++) {
                Register r1 = ll.get(j);
                for(int k = j + 1; k < ll.size(); k++) {
                    Register r2 = ll.get(k);
                    this.ig.connect(r1, r2);
                }
            }
        }
        // make the machine registers pairwise interfering
        ArrayList<MachineReg> regSet = this.rF.getMachineRegisters();
        for(int i = 0; i < regSet.size() - 1; i++)
            for(int j = i+1; j < regSet.size(); j++)
                this.ig.connect(regSet.get(i), regSet.get(j));
    }


    /**
     * This method inserts the new instruction after the old one in the
     * control flow graph.
     */
    public void insertAfterInst(Instruction newInst, Instruction oldInst) {
        // place the new instruction in the control flow graph:
        DiNode<Instruction> node = this.cfg.getNode(oldInst);
        Collection<DiNode<Instruction>> succs = node.succs();
        Collection<DiNode<Instruction>> toBeRemoved = new LinkedList<DiNode<Instruction>>();
        for(DiNode<Instruction> succ : succs) {
            toBeRemoved.add(succ);
            succ.removePred(node);
            this.cfg.connect(newInst, succ.getData());
        }
        for(DiNode<Instruction> succ : toBeRemoved) // avoid concurrent ex
            node.removeSucc(succ);
        this.cfg.connect(oldInst, newInst);
    }


    /**
     * This method inserts the new instruction before the old one in the
     * control flow graph.
     */
    public void insertBeforeInst(Instruction newInst, Instruction oldInst) {
        // place the new instruction in the control flow graph:
        DiNode<Instruction> node = this.cfg.getNode(oldInst);
        Collection<DiNode<Instruction>> preds = node.preds();
        Collection<DiNode<Instruction>> toBeRemoved = new LinkedList<DiNode<Instruction>>();
        for(DiNode<Instruction> pred : preds) {
            toBeRemoved.add(pred);
            pred.removeSucc(node);
            this.cfg.connect(pred.getData(), newInst);
        }
        for(DiNode<Instruction> pred : toBeRemoved) // avoid concurrent ex
            node.removePred(pred);
        this.cfg.connect(newInst, oldInst);
    }

}