package Graph;

import java.io.IOException;

/**
 * The graph reader allows to fill a graph with information from a text file.
 * This functionality has be separated from the graph class because in this
 * way it is possible to load the same graph with different reader; therefore,
 * it is possible to read different file formats.
 */
public class SimpleGraphReader {
    /**
     * This method reads a new graph from the text file.
     * @param fileName the name of the input text file.
     */
    public static Graph<String> read(String fileName) {
        Graph<String> g = new SimpleGraph<String>();
        try {
            java.io.BufferedReader fileReader = new java.io.BufferedReader(new java.io.FileReader(fileName));
            String line = fileReader.readLine();
            while(line != null) {
                java.util.StringTokenizer stk = new java.util.StringTokenizer(line, " -;");
                String currTk = null;
                while(stk.hasMoreTokens()) {
                    String tk = stk.nextToken();
                    g.newNode(tk);
                    if(currTk != null)
                        g.connect(currTk, tk);
                    currTk = tk;
                }
                line = fileReader.readLine();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return g;
    }
}
