package Graph;

/**
 * This interface define factories of nodes. A factory of node is
 * used to allow the graph implementation be independent of the type of node
 * that is been utilized.
 */
public interface NodeFactory<E> {
    /**
     * This method creates a new Node.
     * @param e the internal data of the new node.
     * @return a generic node containing the given internal data.
     */
    public Node<E> create(E e);
}
