package Graph;

import java.util.Collection;

/**
 * This interface represents a node in a graph.
 */
public interface Node<E> {

    /**
     * This method returns a reference to the node internal Data.
     * @return The return value is a generic type. It will be the type of the
     * node key.
     */
    public E getData();


    /**
     * This method inserts a new node among the list of neighbors of this
     * node.
     * @return true if the node parameter was already a neighbor of this node.
     * @param node the successor node.
     */
    public boolean link(Node<E> node);


    /**
     * This method links the current node to all the nodes in the collection.
     * @param a collection of nodes. After this method is called, given any
     * node n in c, this.adj(c) == true;
     */
    public void linkAll(Collection<Node<E>> c);


    /**
     * This method removes a node from the list of successors of this node.
     * @param node the successor node.
     * @return true if this not indeed had such a neighbor. False otherwise.
     */
    public boolean unlink(Node<E> node);


    /**
     * This method removes all nodes from the list of successors of this node.
     */
    public void unlinkAll();


    /**
     * Returns a list of all the neighbors of this node.
     * @return an object of the <CODE>Collection<Node></CODE> type.
     */
    public Collection<Node<E>> neighbors();


    /**
     * Number of neighbors of this node.
     * @return an integer that denotes the number of predecessors of this node.
     * In a oriented graph, a predecessor node is one from which this one can
     * be reached.
     */
    public int degree();


    /**
     * Informs if the given element is a key of one of the successors of this
     * node.
     * @param n a node.
     * @return a <CODE>boolean</CODE> value, that will be true if the given
     * parameter is a successor of this node.
     */
    public boolean adj(Node<E> n);

}
