package Graph;

import java.io.IOException;
import java.util.StringTokenizer;

public class AppelReader {

    public static Graph<String> read(String fileName) {
        Graph<String> graph = new SimpleGraph<String>();
        try {
            java.io.BufferedReader fileReader = new java.io.BufferedReader(new java.io.FileReader(fileName));

            String aux = null;
            String line = fileReader.readLine();
            StringTokenizer st = new StringTokenizer(line);

            // avoid blank lines
            while (st.countTokens() == 0) {
                line = fileReader.readLine();
                st = new StringTokenizer(line);
            }

            // read the graph's name
            st.nextToken();
            st.nextToken();

            // read number of precolored registers
            line = fileReader.readLine();
            aux = line.substring(2);
            int K = Integer.parseInt(aux);
            AppelReader.fillPrecoloredRegisters(graph, K);

            // read the interference relations
            line = fileReader.readLine();
            while(line != null) {
                // resolve interference relations
                AppelReader.fillInterferences(graph, line, K);
                line = fileReader.readLine();
            }

        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return graph;
    }


    private static void fillInterferences(Graph<String> graph, String line, int K) {
        StringTokenizer st = new StringTokenizer(line);
        String r1 = st.nextToken();
        graph.newNode(r1);
        st.nextToken();
        while(st.hasMoreTokens()) {
            String r2 = st.nextToken();
            graph.connect(r1, r2);
        }
    }


    private static void fillPrecoloredRegisters(Graph<String> graph, int K) {
        for(int i = 0; i < K-1; i++) {
            String key = i+"";
            graph.newNode(key);
        }
        for(int i = 0; i < K; i++) {
            String iName = i+"";
            for(int j = i+1; j < K; j++) {
                String jName = j+"";
                graph.connect(iName, jName);
            }
        }
    }

}