package Digraph;

import java.util.HashMap;
import java.util.Collection;

public class SimpleDiNode<E> implements DiNode<E> {

    private HashMap<E, DiNode<E>> preds = null;
    private HashMap<E, DiNode<E>> succs = null;

    private E e;

    protected SimpleDiNode (E e) {
        preds = new HashMap<E, DiNode<E>>();
        succs = new HashMap<E, DiNode<E>>();
        this.e = e;
    }

    /**
     * This method returns a reference to the node internal Data.
     * @return The return value is a generic type. It will be the type of the
     * node key.
     */
    public E getData() {
        return this.e;
    }


    /**
     * This method inserts a new node among the list of successors of this
     * node.
     * @return true if the node parameter was already a neighbor of this node.
     * @param node the successor node.
     */
    public boolean addPred(DiNode<E> node) {
        if(!node.getData().equals(this.getData())) {
            this.preds.put(node.getData(), node);
            return false;
        } else
            return true;
    }


    /**
     * This method inserts a new node among the list of successors of this
     * node.
     * @return true if the node parameter was already a neighbor of this node.
     * @param node the successor node.
     */
    public boolean addSucc(DiNode<E> node) {
        if(!node.getData().equals(this.getData())) {
            this.succs.put(node.getData(), node);
            return false;
        } else
            return true;
    }


    /**
     * This method removes a node from the list of predecessors of this node.
     * @param node the successor node.
     * @return true if this node indeed had such a neighbor. False otherwise.
     */
    public boolean removePred(DiNode<E> node) {
        Object o = this.preds.remove(node.getData());
        if(o == null)
            return false;
        else
            return true;
    }


    /**
     * This method removes a node from the list of successors of this node.
     * @param node the successor node.
     * @return true if this not indeed had such a neighbor. False otherwise.
     */
    public boolean removeSucc(DiNode<E> node) {
        Object o = this.succs.remove(node.getData());
        if(o == null)
            return false;
        else
            return true;
    }


    /**
     * Returns a list of all the predecessors of this node.
     * @return an object of the <CODE>Collection<DiNode></CODE> type.
     */
    public Collection<DiNode<E>> preds() {
        return preds.values();
    }


    /**
     * Returns a list of all the successors of this node.
     * @return an object of the <CODE>Collection<DiNode></CODE> type.
     */
    public Collection<DiNode<E>> succs() {
        return succs.values();
    }


    /**
     * Number of predecessors of this node.
     * @return an integer that denotes the number of predecessors of this node.
     * In a oriented graph, a predecessor node is one from which this one can
     * be reached.
     */
    public int inDegree() {
        return preds.size();
    }


    /**
     * Number of successors of this node.
     * @return an integer that denotes the number of predecessors of this node.
     * In a oriented graph, a successor node is one that can be reached from
     * this node.
     */
    public int outDegree() {
        return succs.size();
    }


    /**
     * Checks if this node is the successor of another one.
     * @param n a node.
     * @return a <CODE>boolean</CODE> value, that will be true if the given
     * parameter is a successor of this node.
     */
    public boolean isSucc(DiNode<E> n) {
        return succs.containsValue(n);
    }


    /**
     * Checks if this node is the predecessor of another one.
     * @param n a node.
     * @return a <CODE>boolean</CODE> value, that will be true if the given
     * parameter is a successor of this node.
     */
    public boolean isPred(DiNode<E> n) {
        return preds.containsValue(n);
    }

    public String toString() {
        String s = e.toString();
        s += "\nPredecessors: ";
        for(DiNode<E> n : preds.values())
            s += n.getData() + " ";
        s += "\nSuccessors: ";
        for(DiNode<E> n : succs.values())
            s += n.getData() + " ";
        return s;
    }

}
