package Digraph;

/**
 * This class defines a factory of oriented nodes. A factory of node is
 * used to allow the graph implementation be independent of the type of node
 * that is been utilized.
 */
public class DiNodeFc<E> implements DiNodeFactory<E> {
    /**
     * This method creates a new Node.
     * @param e the internal data of the new node.
     * @return a generic node containing the given internal data.
     */
    public DiNode<E> create(E e) {
        return new SimpleDiNode<E>(e);
    }
}
