package Digraph;

import java.util.Collection;

/**
 * This interface represents a node in a graph.
 */
public interface DiNode<E> {

    /**
     * This method returns a reference to the node internal Data.
     * @return The return value is a generic type. It will be the type of the
     * node key.
     */
    public E getData();


    /**
     * This method inserts a new node among the list of successors of this
     * node.
     * @return true if the node parameter was already a neighbor of this node.
     * @param node the successor node.
     */
    public boolean addPred(DiNode<E> node);


    /**
     * This method inserts a new node among the list of successors of this
     * node.
     * @return true if the node parameter was already a neighbor of this node.
     * @param node the successor node.
     */
    public boolean addSucc(DiNode<E> node);


    /**
     * This method removes a node from the list of predecessors of this node.
     * @param node the successor node.
     * @return true if this not indeed had such a neighbor. False otherwise.
     */
    public boolean removePred(DiNode<E> node);


    /**
     * This method removes a node from the list of successors of this node.
     * @param node the successor node.
     * @return true if this not indeed had such a neighbor. False otherwise.
     */
    public boolean removeSucc(DiNode<E> node);


    /**
     * Returns a list of all the predecessors of this node.
     * @return an object of the <CODE>Collection<DiNode></CODE> type.
     */
    public Collection<DiNode<E>> preds();


    /**
     * Returns a list of all the successors of this node.
     * @return an object of the <CODE>Collection<DiNode></CODE> type.
     */
    public Collection<DiNode<E>> succs();


    /**
     * Number of predecessors of this node.
     * @return an integer that denotes the number of predecessors of this node.
     * In a oriented graph, a predecessor node is one from which this one can
     * be reached.
     */
    public int inDegree();


    /**
     * Number of successors of this node.
     * @return an integer that denotes the number of predecessors of this node.
     * In a oriented graph, a successor node is one that can be reached from
     * this node.
     */
    public int outDegree();


    /**
     * Checks if this node is the successor of another one.
     * @param n a node.
     * @return a <CODE>boolean</CODE> value, that will be true if the given
     * parameter is a successor of this node.
     */
    public boolean isSucc(DiNode<E> n);


    /**
     * Checks if this node is the predecessor of another one.
     * @param n a node.
     * @return a <CODE>boolean</CODE> value, that will be true if the given
     * parameter is a successor of this node.
     */
    public boolean isPred(DiNode<E> n);

}
