package Digraph;

import java.util.HashSet;
import java.util.Collection;
import java.util.LinkedList;

public class DepthFirstSearch<E> implements Search<E> {

    /**
     * This algorithm works as described below.
     * <PRE>
     *   remove a node from not_visited, insert it in next.
     *   while there are nodes in next:
     *       remove a node n from next.
     *       remove n from toVisit
     *       visit this node.
     *       insert all its neighbors in next.
     * </PRE>
     */
    public void traverse(DiNode<E> startingPoint) {
        HashSet<DiNode<E>> visitedNodes = new HashSet<DiNode<E>>();
        LinkedList<DiNode<E>> next_to_visit = new LinkedList<DiNode<E>>();
        next_to_visit.add(startingPoint);
        while(next_to_visit.size() > 0) {
            DiNode<E> n = next_to_visit.removeLast();
            visitedNodes.add(n);
            this.visit(n);
            Collection<DiNode<E>> succs = n.succs();
            for(DiNode<E> suc : succs) {
                if(!next_to_visit.contains(suc) && !visitedNodes.contains(suc))
                    next_to_visit.add(suc);
            }
        }
    }

    public void visit(DiNode<E> n) {
        System.out.println(n.getData());
    }
}
