import rme.*;
import rme.server.*;
import rme.naming.*;

import java.util.Date;

public class IntensiveClient {

    public static final int NUM_IT = 1;

    public static void main(String a[]) throws Exception {

        if(a.length < 1) {
            System.err.println("Sintaxe: java Client key [host-name]");
            System.exit(1);
        }

        RmeConfigurator c = new RmeConfigurator();
        c.configure();

        String objName = "p1";
        if(a.length > 1)
            objName = a[1];
        Paper paper  = (Paper)RmeNaming.lookup(objName);
        System.out.println("1000 iteractions...");
        Date d1 = new Date();
        for(int i = 0; i < NUM_IT; i++)
            paper.getAbstract();
//        System.out.println("Done");
        for(int i = 0; i < NUM_IT; i++)
            paper.getPDF();
        Date d2 = new Date();
        System.out.println(d2.getTime() - d1.getTime());
    }

}
