import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

import arcademis.security.*;
import java.io.*;
import rme.SNService.*;

public class KeyCreatorPanel extends JPanel implements ActionListener {

    private JButton keyCreatorButton;
    private JButton keyBindButton;
    JTextField fileT;
    JTextField nameT;

    private Mediator mediator;

    /**
     * Creates a panel with elements to define a key. A key is determined
     * by a user name and file name, into which the key should be stored.
     */
    public KeyCreatorPanel(Mediator mediator) {
        this.mediator = mediator;
        this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

        JLabel nameL = new JLabel("User name:");
        this.nameT = new JTextField(20);
        JPanel auxP1 = new JPanel();
        auxP1.setLayout(new FlowLayout());
        auxP1.add(nameL);
        auxP1.add(nameT);
        this.add(auxP1);

        JLabel fileL = new JLabel("File name:");
        this.fileT = new JTextField(20);
        JPanel auxP2 = new JPanel();
        auxP2.setLayout(new FlowLayout());
        auxP2.add(fileL);
        auxP2.add(fileT);
        this.add(auxP2);

        this.keyCreatorButton = new JButton("Create");
        this.keyCreatorButton.addActionListener(this);

        this.keyBindButton = new JButton("Register");
        this.keyBindButton.addActionListener(this);

        JPanel auxP3 = new JPanel();
        auxP3.setLayout(new FlowLayout());
        auxP3.add(this.keyCreatorButton);
        auxP3.add(this.keyBindButton);

        this.add(auxP3);

        this.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("Create/bind key"),
                        BorderFactory.createEmptyBorder(5,5,5,5))
        );
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if(e.getSource() == this.keyBindButton) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileT.getText()));
                Key pubKey, prvKey;
                Signature signature = (Signature)ois.readObject();
                pubKey = (Key)ois.readObject();
                prvKey = (Key)ois.readObject();
                String hostName = mediator.hostT.getText();
                if(hostName != null) {
                    hostName += "/marreta";
                    SecureLookupService.debut(hostName, signature, pubKey);
                }
                else
                    SecureLookupService.debut(signature, pubKey);
            } else if(e.getSource() == this.keyCreatorButton) {
                PersistentData pd1 = new PersistentData();
                String fileName = this.fileT.getText();
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
                pd1.generateData(nameT.getText());
                pd1.storeAtEnd(oos);
                oos.close();
            }
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not open the specified file", "Input error", JOptionPane.ERROR_MESSAGE);
        }
    }
}
